/*
 * Decompiled with CFR 0.152.
 */
package me.angel.challenges6t4.challenge.challenges;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import me.angel.challenges6t4.challenge.Challenge;
import me.angel.challenges6t4.challenge.ChallengeSettings;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1684;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_8111;

public class EnderPearlOnDamageChallenge
extends Challenge {
    private static final boolean DEFAULT_COOLDOWN_ENABLED = false;
    private static final int DEFAULT_COOLDOWN_SECONDS = 3;
    private static final float DEFAULT_MIN_SPEED = 0.5f;
    private static final float DEFAULT_MAX_SPEED = 2.0f;
    private static final float DEFAULT_MIN_ARC = 0.1f;
    private static final float DEFAULT_MAX_ARC = 0.8f;
    private static final String SETTING_COOLDOWN_ENABLED = "cooldown_enabled";
    private static final String SETTING_COOLDOWN_SECONDS = "cooldown_seconds";
    private static final String SETTING_MIN_SPEED = "min_speed";
    private static final String SETTING_MAX_SPEED = "max_speed";
    private static final String SETTING_MIN_ARC = "min_arc";
    private static final String SETTING_MAX_ARC = "max_arc";
    public static final int MIN_COOLDOWN_SECONDS = 1;
    public static final int MAX_COOLDOWN_SECONDS = 10;
    public static final float MIN_SPEED = 0.1f;
    public static final float MAX_SPEED = 5.0f;
    public static final float MIN_ARC = 0.0f;
    public static final float MAX_ARC = 1.0f;
    private final Random random = new Random();
    private final Map<UUID, Long> lastPearlTimes = new HashMap<UUID, Long>();
    private final Set<UUID> recentlyTeleported = new HashSet<UUID>();

    public EnderPearlOnDamageChallenge() {
        super("ender_pearl_on_damage", (class_2561)class_2561.method_43471((String)"challenges6t4.challenge.ender_pearl_on_damage.name"), (class_2561)class_2561.method_43471((String)"challenges6t4.challenge.ender_pearl_on_damage.description"), true, Challenge.MultiplayerStatus.UNTESTED_MULTIPLAYER);
        if (!ChallengeSettings.hasOption(this.getId(), SETTING_COOLDOWN_ENABLED)) {
            this.setCooldownEnabled(false);
        }
        if (!ChallengeSettings.hasOption(this.getId(), SETTING_COOLDOWN_SECONDS)) {
            this.setCooldownSeconds(3);
        }
        if (!ChallengeSettings.hasOption(this.getId(), SETTING_MIN_SPEED)) {
            this.setMinSpeed(0.5f);
        }
        if (!ChallengeSettings.hasOption(this.getId(), SETTING_MAX_SPEED)) {
            this.setMaxSpeed(2.0f);
        }
        if (!ChallengeSettings.hasOption(this.getId(), SETTING_MIN_ARC)) {
            this.setMinArc(0.1f);
        }
        if (!ChallengeSettings.hasOption(this.getId(), SETTING_MAX_ARC)) {
            this.setMaxArc(0.8f);
        }
    }

    @Override
    public boolean isGameBeatable() {
        return true;
    }

    @Override
    public void onEnable() {
    }

    @Override
    public void onDisable() {
        this.lastPearlTimes.clear();
        this.recentlyTeleported.clear();
    }

    public boolean isCooldownEnabled() {
        return ChallengeSettings.getBooleanOption(this.getId(), SETTING_COOLDOWN_ENABLED, false);
    }

    public void setCooldownEnabled(boolean enabled) {
        ChallengeSettings.setBooleanOption(this.getId(), SETTING_COOLDOWN_ENABLED, enabled);
    }

    public int getCooldownSeconds() {
        return ChallengeSettings.getIntOption(this.getId(), SETTING_COOLDOWN_SECONDS, 3);
    }

    public void setCooldownSeconds(int seconds) {
        ChallengeSettings.setIntOption(this.getId(), SETTING_COOLDOWN_SECONDS, seconds);
    }

    public float getMinSpeed() {
        return (float)ChallengeSettings.getIntOption(this.getId(), SETTING_MIN_SPEED, 5) / 10.0f;
    }

    public void setMinSpeed(float speed) {
        ChallengeSettings.setIntOption(this.getId(), SETTING_MIN_SPEED, (int)(speed * 10.0f));
    }

    public float getMaxSpeed() {
        return (float)ChallengeSettings.getIntOption(this.getId(), SETTING_MAX_SPEED, 20) / 10.0f;
    }

    public void setMaxSpeed(float speed) {
        ChallengeSettings.setIntOption(this.getId(), SETTING_MAX_SPEED, (int)(speed * 10.0f));
    }

    public float getMinArc() {
        return (float)ChallengeSettings.getIntOption(this.getId(), SETTING_MIN_ARC, 1) / 10.0f;
    }

    public void setMinArc(float arc) {
        ChallengeSettings.setIntOption(this.getId(), SETTING_MIN_ARC, (int)(arc * 10.0f));
    }

    public float getMaxArc() {
        return (float)ChallengeSettings.getIntOption(this.getId(), SETTING_MAX_ARC, 8) / 10.0f;
    }

    public void setMaxArc(float arc) {
        ChallengeSettings.setIntOption(this.getId(), SETTING_MAX_ARC, (int)(arc * 10.0f));
    }

    public void onPlayerDamage(class_1657 player, class_1282 source, float amount) {
        if (!this.isEnabled() || player.method_37908().field_9236) {
            return;
        }
        if (this.isCooldownEnabled()) {
            long currentTime = System.currentTimeMillis();
            Long lastPearlTime = this.lastPearlTimes.get(player.method_5667());
            if (lastPearlTime != null) {
                long cooldownMs = (long)this.getCooldownSeconds() * 1000L;
                if (currentTime - lastPearlTime < cooldownMs) {
                    return;
                }
            }
        }
        this.spawnEnderPearl(player);
        if (this.isCooldownEnabled()) {
            this.lastPearlTimes.put(player.method_5667(), System.currentTimeMillis());
        }
    }

    private void spawnEnderPearl(class_1657 player) {
        class_1937 world = player.method_37908();
        float speed = this.getMinSpeed() + this.random.nextFloat() * (this.getMaxSpeed() - this.getMinSpeed());
        float arc = this.getMinArc() + this.random.nextFloat() * (this.getMaxArc() - this.getMinArc());
        double angle = this.random.nextDouble() * 2.0 * Math.PI;
        double horizontalX = Math.cos(angle);
        double horizontalZ = Math.sin(angle);
        double velocityX = horizontalX * (double)speed;
        double velocityY = arc * speed;
        double velocityZ = horizontalZ * (double)speed;
        class_1684 enderPearl = new class_1684(world, (class_1309)player);
        enderPearl.method_16940(class_1802.field_8634.method_7854());
        enderPearl.method_5814(player.method_23317(), player.method_23318() + (double)player.method_18381(player.method_18376()), player.method_23321());
        enderPearl.method_18800(velocityX, velocityY, velocityZ);
        enderPearl.method_7432((class_1297)player);
        world.method_8649((class_1297)enderPearl);
    }

    public void markPlayerTeleported(UUID playerUuid) {
        if (this.isEnabled()) {
            this.recentlyTeleported.add(playerUuid);
        }
    }

    public boolean shouldCancelEnderPearlDamage(UUID playerUuid, class_1282 source) {
        if (!this.isEnabled()) {
            return false;
        }
        if (source.method_49708(class_8111.field_42345) && this.recentlyTeleported.contains(playerUuid)) {
            this.recentlyTeleported.remove(playerUuid);
            return true;
        }
        return false;
    }
}

